/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.ValuePair;
import com.lycanitesmobs.core.config.ConfigSpawning;
import com.lycanitesmobs.core.mobevent.MobEventBase;
import com.lycanitesmobs.core.mobevent.MobEventClient;
import com.lycanitesmobs.core.mobevent.MobEventManager;
import com.lycanitesmobs.core.mobevent.MobEventServer;
import com.lycanitesmobs.core.mobevent.MobEventServerBoss;
import com.lycanitesmobs.core.network.MessageMobEvent;
import com.lycanitesmobs.core.network.MessageWorldEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import org.apache.commons.lang3.math.NumberUtils;

public class ExtendedWorld
extends WorldSavedData {
    public static String EXT_PROP_NAME = "LycanitesMobs";
    public static Map<World, ExtendedWorld> loadedExtWorlds = new HashMap<World, ExtendedWorld>();
    public World world;
    public long lastEventUpdateTime = 0L;
    public int lastEventScheduleMinute = -1;
    public boolean configLoaded = false;
    public boolean useTotalWorldTime = true;
    public int minTicksUntilEvent = 72000;
    public int maxTicksUntilEvent = 144000;
    public boolean mobEventsEnabled = true;
    public boolean mobEventsRandom = true;
    public String mobEventsSchedule = "";
    public boolean eventScheduleLoaded = false;
    public boolean mobEventsLocked = false;
    public boolean mobEventsLockedOnlyOnSchedule = true;
    public int minEventsRandomDay = 0;
    public List<MobEventServer> serverMobEvents = new ArrayList<MobEventServer>();
    public Map<String, MobEventClient> clientMobEvents = new HashMap<String, MobEventClient>();
    public Map<ValuePair<Integer, Integer>, MobEventBase> eventSchedule;
    public MobEventServer serverWorldEvent = null;
    public MobEventClient clientWorldEvent = null;
    private long worldEventStartTargetTime = 0L;
    private long worldEventLastStartedTime = 0L;
    private String worldEventType = "";
    private int worldEventCount = -1;

    public static ExtendedWorld getForWorld(World world) {
        ExtendedWorld worldExt;
        WorldSavedData worldSavedData;
        if (world == null) {
            return null;
        }
        if (loadedExtWorlds.containsKey(world)) {
            ExtendedWorld worldExt2 = loadedExtWorlds.get(world);
            return worldExt2;
        }
        if (World.MAX_ENTITY_RADIUS < 50.0) {
            World.MAX_ENTITY_RADIUS = 50.0;
        }
        if ((worldSavedData = world.getPerWorldStorage().func_75742_a(ExtendedWorld.class, EXT_PROP_NAME)) != null) {
            worldExt = (ExtendedWorld)worldSavedData;
            worldExt.world = world;
            worldExt.init();
        } else {
            worldExt = new ExtendedWorld(world);
            world.getPerWorldStorage().func_75745_a(EXT_PROP_NAME, (WorldSavedData)worldExt);
        }
        loadedExtWorlds.put(world, worldExt);
        return worldExt;
    }

    public ExtendedWorld(String prop_name) {
        super(EXT_PROP_NAME);
    }

    public ExtendedWorld(World world) {
        super(EXT_PROP_NAME);
        this.world = world;
    }

    public void init() {
        this.loadConfig();
        this.lastEventUpdateTime = this.world.func_82737_E() - 1L;
        int currentTotalMinutes = (int)Math.floor((double)(this.useTotalWorldTime ? this.world.func_82737_E() : this.world.func_72820_D()) / 1000.0);
        this.lastEventScheduleMinute = currentTotalMinutes % 24;
        if (!this.world.field_72995_K && !"".equals(this.getWorldEventType()) && this.serverWorldEvent == null) {
            long savedLastStartedTime = this.getWorldEventLastStartedTime();
            this.startWorldEvent(this.getWorldEventType());
            if (this.serverWorldEvent != null) {
                this.serverWorldEvent.changeStartedWorldTime(savedLastStartedTime);
            }
        }
    }

    public void loadConfig() {
        ConfigSpawning config = ConfigSpawning.getConfig(LycanitesMobs.group, "mobevents");
        this.mobEventsEnabled = config.getBool("World", this.getConfigEntryName("Mob Events Enabled"), this.mobEventsEnabled, "If false, all mob events will be completely disabled.");
        this.mobEventsRandom = config.getBool("World", this.getConfigEntryName("Random Mob Events"), this.mobEventsRandom, "If false, mob events will no longer occur randomly but can still occur via other means such as by schedule. Set this to true if you want both random and scheduled events to take place and also take a look at 'Lock Random Mob Events' if doing so.");
        this.minEventsRandomDay = config.getInt("World", this.getConfigEntryName("Random Mob Events Day Minimum"), this.minEventsRandomDay, "If random events are enabled, they wont occur until this day is reached. Set to 0 to have random events enabled from the start of a world.");
        this.mobEventsSchedule = config.getString("World", this.getConfigEntryName("Mob Events Schedule"), this.mobEventsSchedule, "Here you can add a list of scheduled events, leave blank to disable. Each entry should be: 'eventname,day,time' multiple entries should be separated by semicolons. For eventnames use '/lm mobevent list' when in game. Day is the target day number starting from day 0, see 'Use Total World Time' for how the world time is checked. Time is the minute of the in game day that the event should occur (there is 20 minutes in a Minecraft day/night cycle use 0-19), this can also be random by typing 'random' as a value, note that you can only have 1 random scheduled event per day. You may add spaces anywhere as they will be ignored, also don't add the 'quotations'!");
        this.mobEventsLocked = config.getBool("World", this.getConfigEntryName("Lock Random Mob Events"), this.mobEventsLocked, "If true, mob events will not occur randomly until they have been started from a schedule (or if an active world's schedule would have started the event at least once in the past).");
        this.mobEventsLockedOnlyOnSchedule = config.getBool("World", this.getConfigEntryName("Lock Random Mob Events Only On Schedule"), this.mobEventsLockedOnlyOnSchedule, "Only used if 'Lock Random Mob Events' is set to true. If true, mob events that are scheduled will be locked from occuring randomly but mob events that aren't on a schedule will be unlocked. If false, all events that are not scheduled at least once will never occur randomly as they cannot be unlocked.");
        this.useTotalWorldTime = config.getBool("World", this.getConfigEntryName("Use Total World Time"), this.useTotalWorldTime, "If true, the hidden total world time will be used for random event minimum days and scheduled events, if false the current world time is used instead, the current time is the time shown to players however it will reset to 0 if the world time is change via '/time set 0' or other commands/mods.");
        this.minTicksUntilEvent = config.getInt("World", this.getConfigEntryName("Min Ticks Until Random Event"), this.minTicksUntilEvent, "Minimum time in ticks until a random event can occur. 20 Ticks = 1 Second.");
        this.maxTicksUntilEvent = config.getInt("World", this.getConfigEntryName("Max Ticks Until Random Event"), this.maxTicksUntilEvent, "Maximum time in ticks until a random event can occur. 20 Ticks = 1 Second.");
        this.configLoaded = true;
    }

    protected String getConfigEntryName(String name) {
        return name + " " + this.world.field_73011_w.func_186058_p().func_186065_b() + " (" + this.world.field_73011_w.getDimension() + ")";
    }

    public long getWorldEventStartTargetTime() {
        return this.worldEventStartTargetTime;
    }

    public long getWorldEventLastStartedTime() {
        return this.worldEventLastStartedTime;
    }

    public String getWorldEventType() {
        return this.worldEventType;
    }

    public int getWorldEventCount() {
        return this.worldEventCount;
    }

    public void setWorldEventStartTargetTime(long setLong) {
        if (this.worldEventStartTargetTime != setLong) {
            this.func_76185_a();
        }
        this.worldEventStartTargetTime = setLong;
        if (setLong > 0L) {
            LycanitesMobs.printDebug("MobEvents", "Next random mob will start after " + (this.worldEventStartTargetTime - this.world.func_82737_E()) / 20L + "secs.");
        }
    }

    public void setWorldEventLastStartedTime(long setLong) {
        if (this.worldEventLastStartedTime != setLong) {
            this.func_76185_a();
        }
        this.worldEventLastStartedTime = setLong;
    }

    public void setWorldEventType(String setString) {
        if (!this.worldEventType.equals(setString)) {
            this.func_76185_a();
        }
        this.worldEventType = setString;
    }

    public void increaseMobEventCount() {
        ++this.worldEventCount;
    }

    public void loadEventSchedule(String schedule) {
        this.eventScheduleLoaded = true;
        if ("".equals(schedule = schedule.replace(" ", ""))) {
            return;
        }
        this.eventSchedule = new HashMap<ValuePair<Integer, Integer>, MobEventBase>();
        for (String scheduleEntry : schedule.split(";")) {
            MobEventBase scheduleEntryEvent;
            String[] scheduleEntryParts = scheduleEntry.split(",");
            if (scheduleEntryParts.length < 3 || !NumberUtils.isNumber((String)scheduleEntryParts[1])) continue;
            int scheduleEntryDay = Integer.parseInt(scheduleEntryParts[1]);
            int scheduleEntryMinute = -1;
            if (!"random".equals(scheduleEntryParts[2])) {
                if (!NumberUtils.isNumber((String)scheduleEntryParts[2])) continue;
                scheduleEntryMinute = Integer.parseInt(scheduleEntryParts[2]);
            }
            if (!MobEventManager.instance.worldMobEvents.containsKey(scheduleEntryParts[0]) || (scheduleEntryEvent = MobEventManager.instance.worldMobEvents.get(scheduleEntryParts[0])) == null) continue;
            if (scheduleEntryDay < scheduleEntryEvent.firstScheduleDay || scheduleEntryEvent.firstScheduleDay < 0) {
                scheduleEntryEvent.firstScheduleDay = scheduleEntryDay;
            }
            this.eventSchedule.put(new ValuePair<Integer, Integer>(scheduleEntryDay, scheduleEntryMinute), scheduleEntryEvent);
            LycanitesMobs.printDebug("MobEvents", "Added Event to Schedule: " + scheduleEntryEvent.getTitle() + " (" + scheduleEntryParts[0] + ") Starts On Day " + scheduleEntryDay + " At Minute " + (scheduleEntryMinute < 0 ? "Random" : Integer.valueOf(scheduleEntryMinute)));
        }
    }

    public MobEventBase getScheduledWorldMobEvent() {
        if (this.eventSchedule == null) {
            return null;
        }
        int dimensionID = 0;
        if (this.world.field_73011_w != null) {
            dimensionID = this.world.field_73011_w.getDimension();
        }
        int currentDay = (int)Math.floor((double)(this.useTotalWorldTime ? this.world.func_82737_E() : this.world.func_72820_D()) / 24000.0);
        int currentMin = (int)((long)Math.floor((double)(this.useTotalWorldTime ? this.world.func_82737_E() : this.world.func_72820_D()) / 1200.0) % 20L);
        if (this.lastEventScheduleMinute != currentMin) {
            this.lastEventScheduleMinute = currentMin;
            LycanitesMobs.printDebug("MobEvents", "Checking world day and minute for scheduled event... Day " + currentDay + " Minute " + currentMin);
            if (currentMin == 0 && this.eventSchedule.containsKey(new ValuePair<Integer, Integer>(currentDay, -1))) {
                MobEventBase randomMinuteEvent = this.eventSchedule.get(new ValuePair<Integer, Integer>(currentDay, -1));
                int randomMin = currentMin + 1 + this.world.field_73012_v.nextInt(18 - currentMin);
                LycanitesMobs.printDebug("MobEvents", "Found a random event that needs assigned a minute (" + (randomMinuteEvent != null ? randomMinuteEvent.name : "null") + "), setting random minute to " + randomMin + " this should from 1 to 19.");
                this.eventSchedule.put(new ValuePair<Integer, Integer>(currentDay, randomMin), randomMinuteEvent);
                this.eventSchedule.remove(new ValuePair<Integer, Integer>(currentDay, -1));
            }
            if (this.eventSchedule.containsKey(new ValuePair<Integer, Integer>(currentDay, currentMin))) {
                MobEventBase scheduledEvent = this.eventSchedule.get(new ValuePair<Integer, Integer>(currentDay, currentMin));
                LycanitesMobs.printDebug("MobEvents", "Found a scheduled event (" + (scheduledEvent != null ? scheduledEvent.name : "null") + "), this event will now start...");
                return scheduledEvent;
            }
            LycanitesMobs.printDebug("MobEvents", "No scheduled event found for this day and minute.");
        }
        return null;
    }

    public int getRandomEventDelay(Random random) {
        int min;
        int max = Math.max(20, this.maxTicksUntilEvent);
        if (max <= (min = Math.max(20, this.minTicksUntilEvent))) {
            return min;
        }
        return min + random.nextInt(max - min);
    }

    public void startWorldEvent(MobEventBase mobEvent) {
        if (mobEvent == null) {
            LycanitesMobs.printWarning("", "Tried to start a null world event, stopping any event instead.");
            this.stopWorldEvent();
            return;
        }
        if (!this.world.field_72995_K) {
            this.serverWorldEvent = mobEvent.getServerEvent(this.world);
            this.setWorldEventType(mobEvent.name);
            this.increaseMobEventCount();
            this.setWorldEventStartTargetTime(0L);
            this.setWorldEventLastStartedTime(this.world.func_82737_E());
            this.serverWorldEvent.onStart();
            this.updateAllClientsEvents();
        }
        if (this.world.field_72995_K) {
            boolean extended = false;
            if (this.clientWorldEvent != null) {
                extended = this.clientWorldEvent.mobEvent == mobEvent;
            }
            this.clientWorldEvent = mobEvent.getClientEvent(this.world);
            this.clientWorldEvent.extended = extended;
            if (LycanitesMobs.proxy.getClientPlayer() != null) {
                this.clientWorldEvent.onStart(LycanitesMobs.proxy.getClientPlayer());
            }
        }
    }

    public void startWorldEvent(String mobEventName) {
        MobEventBase mobEvent;
        if (MobEventManager.instance.worldMobEvents.containsKey(mobEventName)) {
            mobEvent = MobEventManager.instance.worldMobEvents.get(mobEventName);
            if (!mobEvent.isEnabled()) {
                LycanitesMobs.printWarning("", "Tried to start a world event that was disabled with the name: '" + mobEventName + "' on " + (this.world.field_72995_K ? "Client" : "Server"));
                return;
            }
        } else {
            LycanitesMobs.printWarning("", "Tried to start a world event with the invalid name: '" + mobEventName + "' on " + (this.world.field_72995_K ? "Client" : "Server"));
            return;
        }
        this.startWorldEvent(mobEvent);
    }

    public void stopWorldEvent() {
        if (this.serverWorldEvent != null) {
            this.serverWorldEvent.onFinish();
            this.setWorldEventType("");
            this.serverWorldEvent = null;
            this.updateAllClientsEvents();
        }
        if (this.clientWorldEvent != null) {
            if (LycanitesMobs.proxy.getClientPlayer() != null) {
                this.clientWorldEvent.onFinish(LycanitesMobs.proxy.getClientPlayer());
            }
            this.clientWorldEvent = null;
        }
    }

    public void startMobEvent(MobEventBase mobEvent, int originX, int originY, int originZ, int rank) {
        boolean extended;
        if (mobEvent == null) {
            LycanitesMobs.printWarning("", "Tried to start a null mob event.");
            return;
        }
        if (!this.world.field_72995_K) {
            MobEventServer mobEventServer = mobEvent.getServerEvent(this.world);
            this.serverMobEvents.add(mobEventServer);
            if (mobEventServer instanceof MobEventServerBoss) {
                MobEventServerBoss mobEventServerBoss = (MobEventServerBoss)mobEventServer;
                mobEventServerBoss.originX = originX;
                mobEventServerBoss.originY = originY;
                mobEventServerBoss.originZ = originZ;
            }
            mobEventServer.rank = rank;
            mobEventServer.onStart();
            this.updateAllClientsEvents();
        }
        if (this.world.field_72995_K && !(extended = false)) {
            MobEventClient mobEventClient = mobEvent.getClientEvent(this.world);
            this.clientMobEvents.put(mobEvent.name, mobEventClient);
            mobEventClient.extended = extended;
            if (LycanitesMobs.proxy.getClientPlayer() != null) {
                mobEventClient.onStart(LycanitesMobs.proxy.getClientPlayer());
            }
        }
    }

    public MobEventBase startMobEvent(String mobEventName, int originX, int originY, int originZ) {
        return this.startMobEvent(mobEventName, originX, originY, originZ, 0);
    }

    public MobEventBase startMobEvent(String mobEventName, int originX, int originY, int originZ, int rank) {
        MobEventBase mobEvent;
        if (MobEventManager.instance.allMobEvents.containsKey(mobEventName)) {
            mobEvent = MobEventManager.instance.allMobEvents.get(mobEventName);
            if (!mobEvent.isEnabled()) {
                LycanitesMobs.printWarning("", "Tried to start a mob event that was disabled with the name: '" + mobEventName + "' on " + (this.world.field_72995_K ? "Client" : "Server"));
                return null;
            }
        } else {
            LycanitesMobs.printWarning("", "Tried to start a mob event with the invalid name: '" + mobEventName + "' on " + (this.world.field_72995_K ? "Client" : "Server"));
            return null;
        }
        this.startMobEvent(mobEvent, originX, originY, originZ, rank);
        return mobEvent;
    }

    public int getNextMobEventIndex() {
        return this.serverMobEvents.size() + 1;
    }

    public void stopMobEvent(MobEventServer mobEventServer) {
        if (this.serverMobEvents.contains(mobEventServer)) {
            mobEventServer.onFinish();
            this.serverMobEvents.remove(mobEventServer);
            this.updateAllClientsEvents();
        }
    }

    public void stopMobEvent(String mobEventName) {
        if (this.clientMobEvents.get(mobEventName) != null) {
            if (LycanitesMobs.proxy.getClientPlayer() != null) {
                this.clientMobEvents.get(mobEventName).onFinish(LycanitesMobs.proxy.getClientPlayer());
            }
            this.clientMobEvents.put(mobEventName, null);
        }
    }

    public void updateAllClientsEvents() {
        MessageWorldEvent message = new MessageWorldEvent(this.getWorldEventType());
        LycanitesMobs.packetHandler.sendToDimension(message, this.world.field_73011_w.getDimension());
        for (MobEventServer mobEventServer : this.serverMobEvents) {
            MessageMobEvent messageMobEvent = new MessageMobEvent(mobEventServer.mobEvent != null ? mobEventServer.mobEvent.name : "");
            LycanitesMobs.packetHandler.sendToDimension(messageMobEvent, this.world.field_73011_w.getDimension());
        }
    }

    public void func_76184_a(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("WorldEventStartTargetTime")) {
            this.worldEventStartTargetTime = nbtTagCompound.func_74762_e("WorldEventStartTargetTime");
        }
        if (nbtTagCompound.func_74764_b("WorldEventLastStartedTime")) {
            this.worldEventLastStartedTime = nbtTagCompound.func_74762_e("WorldEventLastStartedTime");
        }
        if (nbtTagCompound.func_74764_b("WorldEventType")) {
            this.worldEventType = nbtTagCompound.func_74779_i("WorldEventType");
        }
        if (nbtTagCompound.func_74764_b("WorldEventCount")) {
            this.worldEventCount = nbtTagCompound.func_74762_e("WorldEventCount");
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74772_a("WorldEventStartTargetTime", this.worldEventStartTargetTime);
        nbtTagCompound.func_74772_a("WorldEventLastStartedTime", this.worldEventLastStartedTime);
        nbtTagCompound.func_74778_a("WorldEventType", this.worldEventType);
        nbtTagCompound.func_74768_a("WorldEventCount", this.worldEventCount);
        return nbtTagCompound;
    }
}

